/*! \file
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit source file
*
* Filename:                     tlk_odrm_llf_types.h
*
* Project, Target, subsystem:   Toolkit, OMA DRM
*
* Created:                      03.01.2008
*
* Modified:                     03.01.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_ODRM_LLF_TYPES_H_
#define _TLK_ODRM_LLF_TYPES_H_

#include "DX_VOS_BaseTypes.h"

#include "CRYS_RSA_Types.h"

#include "tlk_odrm_api.h"
#include "tlk_odrm_def.h"
#include "tlk_odrm_llf_defs.h"
/************************************************************************/
/* Temporary buffers for keeping SYMMETRIC passwords and keys           */
/************************************************************************/
typedef struct
{
    DxUint8_t keyRingKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t aesKmngKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t unwrappedKmngAesKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];

    DxUint8_t keyRingKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t aesKmngKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t unwrappedKmngAesKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];

    DxUint8_t aesKeyBuff[TLK_ODRM_LLF_AES_WRAP_KEY_MAX_LENGTH_IN_BYTES];

}TLK_ODRM_LLF_AesUnwrapAndStoreParams_t;

typedef struct
{
    DxUint8_t keyRingKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t aesKmngKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t decrypedKmngAesKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];

    DxUint8_t keyRingKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t aesKmngKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t decrypedKmngAesKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];

    DxUint8_t encryptedKeyBuff[TLK_ODRM_LLF_AES_ENCRYPT_KEY_MAX_LENGTH_IN_BYTES];
}TLK_ODRM_LLF_AesKeyDecryptAndStoreParams_t;

typedef struct
{
    DxUint8_t deviceKeyRingKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t keysKeyRingKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t devicePrivateKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t firstKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t secondKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];

    DxUint8_t deviceKeyRingKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t keysKeyRingKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t devicePrivateKey[TLK_ODRM_RSA_WRAPPED_KEY_SIZE_IN_BYTES];
    
    DxUint8_t cString[TLK_ODRM_LLF_AES_ENCRYPT_KEY_MAX_LENGTH_IN_BYTES];
}TLK_ODRM_LLF_KeysDeriveUnderDeviceParams_t;

typedef struct
{
    DxUint8_t keyRingKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t domainKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t kMacKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t kRekKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];

    DxUint8_t keysKeyRingKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t domainKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    
    DxUint8_t cString[TLK_ODRM_C_LENGTH_IN_BYTES];
}TLK_ODRM_LLF_KmacAndKrekDeriveUnderDomainKeyParams_t;

typedef struct
{
    DxUint8_t keysRingKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t kMacKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t kMekKeyPassword[TLK_ODRM_LLF_KMNG_MAX_PASSWORD_LENGTH_IN_BYTES];
    DxUint8_t keysRingKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t kMacKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    DxUint8_t kMekKey[TLK_ODRM_LLF_INPUT_SYM_KEY_LENGTH_IN_BYTES];
    CRYS_RSAUserPubKey_t riKey;
    DxUint8_t cString[TLK_ODRM_C_LENGTH_IN_BYTES];
}TLK_ODRM_LLF_KmacAndKmekEncryptUnderKriParams_t;

typedef union
{
    TLK_ODRM_LLF_AesUnwrapAndStoreParams_t                  aesUnwrapAndStoreParams;
    TLK_ODRM_LLF_AesKeyDecryptAndStoreParams_t              aesKeyDecryptAndStoreParams;
    TLK_ODRM_LLF_KeysDeriveUnderDeviceParams_t              keysDeriveUnderDeviceKeyParams;
    TLK_ODRM_LLF_KmacAndKrekDeriveUnderDomainKeyParams_t    kMacAndkRekDeriveUnderDomainKeyParams;
    TLK_ODRM_LLF_KmacAndKmekEncryptUnderKriParams_t         kMacAndkMekEncryptUnderKriParams;
}DX_SEP_PARSE_TLK_ODRM_LLF_t;

#ifdef TLK_ODRM_SEP_SIMULATOR
typedef union
{
 DX_SEP_PARSE_TLK_ODRM_LLF_t             tlkOdrmBuffer;
}DX_SEP_PARSE_GLOBAL_CONTEXT_t;
#endif

/*#define TLK_ODRM_SEP_DEBUG_PRINTS 1*/

#ifdef TLK_ODRM_SEP_DEBUG_PRINTS
#include <stdio.h>
#define ODRM_TLK_SEP_DBGPRINT(message, param) \
	printf("ODRM_ERR: f:%s l:%d %s (0x%08X)\n",__FILE__, __LINE__,message, param)

#define ODRM_SEP_RETURN_VAR_STATUS(errorCode)	\
	do {	\
	DxStatus localCode = (DxStatus)errorCode;	\
	if (localCode != DX_SUCCESS)	\
	ODRM_TLK_SEP_DBGPRINT("Returning Error Code:", localCode);	\
	DX_RETURN(localCode);	\
	} while (0)

#define ODRM_SEP_RETURN_CONST_STATUS(errorCode)	\
	do {	\
	ODRM_TLK_SEP_DBGPRINT("Returning Error Code:", errorCode);	\
	DX_RETURN(errorCode);	\
	} while (0)

#define ODRM_SEP_GOTO_END_WITH_CONST_STATUS(errorCode)\
	do {	\
	ODRM_TLK_SEP_DBGPRINT("Returning Error Code:", errorCode);	\
	result = errorCode; \
	goto end;	\
	} while (0)

#define ODRM_SEP_GOTO_END_WITH_VAR_STATUS(errorCode)\
	do {	\
	result = (DxUint32)errorCode;	\
	if (result != DX_SUCCESS)	\
	ODRM_TLK_SEP_DBGPRINT("Returning Error Code:", result);	\
	goto end;   \
	} while (0)

#else 
#define ODRM_TLK_SEP_DBGPRINT(message, param)
#define ODRM_SEP_RETURN_VAR_STATUS(errorCode) return errorCode
#define ODRM_SEP_RETURN_CONST_STATUS(errorCode) return errorCode
#define ODRM_SEP_GOTO_END_WITH_CONST_STATUS(errorCode) do { result = errorCode; goto end; } while (0)
#define ODRM_SEP_GOTO_END_WITH_VAR_STATUS(errorCode) goto end
#endif /*TLK_ODRM_SEP_DEBUG_PRINTS*/

#define ODRM_SEP_RETURN_IF_ALLOC_FAILED(ptr)	\
	if (ptr == DX_NULL) ODRM_SEP_RETURN_CONST_STATUS(DX_MEM_ALLOCATION_ERROR)

#define ODRM_SEP_GOTO_END_IF_ALLOC_FAILED(ptr)	\
	if (ptr == DX_NULL) ODRM_SEP_GOTO_END_WITH_CONST_STATUS(DX_MEM_ALLOCATION_ERROR)

#endif
